// $Id: CAudioBuffer.cpp,v 1.5 2007/02/08 21:08:09 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAudioBuffer.hpp"
using Exponent::Audio::CAudioBuffer;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAudioBuffer, CCountedObject);

//	===========================================================================
const double CAudioBuffer::CAUDIO_BUFFER_DENORMAL = 1e-15;

//	===========================================================================
CAudioBuffer::CAudioBuffer(const long bufferSize) : m_waveData(NULL), m_bufferSize(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CAudioBuffer);
	this->initialise(bufferSize);
}

//	===========================================================================
CAudioBuffer::CAudioBuffer() : m_waveData(NULL), m_bufferSize(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CAudioBuffer);
	m_bufferSize = 0;
	NULL_POINTER(m_waveData);
}

//	===========================================================================
CAudioBuffer::~CAudioBuffer()
{
	EXPONENT_CLASS_DESTRUCTION(CAudioBuffer);
	this->uninitialise();
}

//	===========================================================================
void CAudioBuffer::initialise(const long bufferSize)
{
	m_bufferSize	  = bufferSize;

	m_waveData	  = new double*[2];
	m_waveData[0] = new double[bufferSize];
	m_waveData[1] = new double[bufferSize];

	memset(m_waveData[0], 0, bufferSize * sizeof(double));
	memset(m_waveData[1], 0, bufferSize * sizeof(double));
}

//	===========================================================================
void CAudioBuffer::uninitialise()
{
	FREE_ARRAY_POINTER(m_waveData[0]);
	FREE_ARRAY_POINTER(m_waveData[1]);
	FREE_ARRAY_POINTER(m_waveData);
}

//	===========================================================================
void CAudioBuffer::reInitialise(const long bufferSize)
{
	this->uninitialise();
	this->initialise(bufferSize);
}

//	===========================================================================
void CAudioBuffer::getMaxSamples(double &left, double &right)
{
	// Some buffers
	double theLeft  = 0.0;
	double theRight = 0.0;

	// Default values
	left = right = 0.0;

	// Loop and find the max
	for (long i = 0; i < m_bufferSize; i++)
	{
		theLeft  = fabs(m_waveData[0][i]);
		theRight = fabs(m_waveData[1][i]);

		if (theLeft > left)
		{
			left = theLeft;
		}
		if (theRight > right)
		{
			right = theRight;
		}
	}
}